/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame.entities.creatures;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.entities.Entity;

public abstract class Creature
extends Entity {
    public static final int DEFAULT_HEALTH = 100;
    public static final int DEFAULT_POWER = 5;
    public static final int DEFAULT_SUPER_POWER = 50;
    public static final float DEFAULT_SPEED = 3.0f;
    public static final float DEFAULT_JUMP = 8.0f;
    public static final int DEFAULT_JUMP_FRAMES = 15;
    public static final int DEFAULT_CREATURE_WIDTH = 64;
    public static final int DEFAULT_CREATURE_HEIGHT = 64;
    protected int health = 100;
    protected int power = 5;
    protected int superPower = 50;
    protected float speed = 3.0f;
    protected float jump = 8.0f;
    protected int jump_frames = 15;
    protected float xMove = 0.0f;
    protected float yMove = 0.0f;
    boolean jUp = false;
    boolean jDown = false;
    int jumpCount = this.jump_frames;
    protected int attackCounter = 0;
    protected boolean leftPunch = false;
    protected boolean rightPunch = false;
    protected boolean leftKick = false;
    protected boolean rightKick = false;
    protected boolean leftsuper = false;
    protected boolean rightSuper = false;
    protected boolean block = false;
    protected int blockCounter = 0;
    protected int blockCounter2 = 0;
    protected boolean superUsed = false;

    public Creature(Handler handler, float x, float y, int width, int height) {
        super(handler, x, y, width, height);
    }

    public void move() {
        this.moveX();
        this.moveY();
    }

    public void moveX() {
        if (this.xMove > 0.0f) {
            int tx = (int)(this.x + this.xMove + (float)this.bounds.x + (float)this.bounds.width) / 64;
            this.x = !this.collisionWithTile(tx, (int)(this.y + (float)this.bounds.y) / 64) && !this.collisionWithTile(tx, (int)(this.y + (float)this.bounds.y + (float)this.bounds.height) / 64) ? (this.x += this.xMove) : (float)(tx * 64 - this.bounds.x - this.bounds.width - 1);
        } else if (this.xMove < 0.0f) {
            int tx = (int)(this.x + this.xMove + (float)this.bounds.x) / 64;
            this.x = !this.collisionWithTile(tx, (int)(this.y + (float)this.bounds.y) / 64) && !this.collisionWithTile(tx, (int)(this.y + (float)this.bounds.y + (float)this.bounds.height) / 64) ? (this.x += this.xMove) : (float)(tx * 64 + 64 - this.bounds.x);
        }
    }

    public void moveY() {
        if (this.yMove < 0.0f) {
            int ty = (int)(this.y + this.yMove + (float)this.bounds.y) / 64;
            if (!this.collisionWithTile((int)(this.x + (float)this.bounds.x) / 64, ty) && !this.collisionWithTile((int)(this.x + (float)this.bounds.x + (float)this.bounds.width) / 64, ty)) {
                this.y += this.yMove;
                this.jUp = true;
                --this.jumpCount;
                if (this.jumpCount == 0) {
                    this.jUp = false;
                }
            } else {
                this.y = ty * 64 + 64 - this.bounds.y;
            }
        } else if (this.yMove > 0.0f) {
            int ty = (int)(this.y + this.yMove + (float)this.bounds.y + (float)this.bounds.height) / 64;
            if (!this.collisionWithTile((int)(this.x + (float)this.bounds.x) / 64, ty) && !this.collisionWithTile((int)(this.x + (float)this.bounds.x + (float)this.bounds.width) / 64, ty)) {
                this.y += this.yMove;
            } else {
                this.y = ty * 64 - this.bounds.y - this.bounds.height - 1;
                this.jumpCount = this.jump_frames;
            }
        }
    }

    protected boolean collisionWithTile(int x, int y) {
        return this.handler.getWorld().getTile(x, y).isSolid();
    }

    public float getxMove() {
        return this.xMove;
    }

    public void setxMove(float xMove) {
        this.xMove = xMove;
    }

    public float getyMove() {
        return this.yMove;
    }

    public void setyMove(float yMove) {
        this.yMove = yMove;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getBlockCounter() {
        return this.blockCounter;
    }

    public int getBlockCounter2() {
        return this.blockCounter2;
    }

    public boolean isBlock() {
        return this.block;
    }
}

